# program to select jokes on a certain subject in the science jokes collection.

# Search jokes selected on subject:
# Usage : awk -f select.awk  sel=X scijokes.txt > seljokes.txt 
#            to select jokes on a subject.
# x is the code for the selected subject:
#M mathematics ; P physics ; C chemistry ; B biology ; E engineering
#A computer science.

BEGIN {
border=\
"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++"
c0=0 ; c1=0 ; new=0
}
(!sel) {
# usage notice.
  print "Usage: awk -f select.awk sel=X scijokes.txt > selected.jokes.txt"
  print "\tWhere X is the code for the selected subject:"
  print " M mathematics ; P physics ; C chemistry ; B biology ; E engineering"
  print " A computer science"
  exit
}

# introduction
/^Version/ && (!starter) {
 starter=1 ; selecting=0;
 printf("SELECTED SCIENCE JOKES\n")
}
# new subsection
/^=[0-9]+\.[0-9]+ / && !/[a-z]/ { c1=0 ; subtitle=$0 ; next }
# new section
/^=[0-9]+\. / && !/[a-z]/ { c0=0 ; c1=1; title=$0 ; next }
# next joke - unselect
/^[*&MBPCEA]*______________________+$/ { new=0 }
# end section = end joke
/^\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\+\++$/ {new=0 ; selecting=1}

# selected joke # THIS DECIDES FOR WHAT YOU SELECT:
/^[*&MBPCEA]*______________________+$/ && ($0~toupper(sel)) {
  new=1;
  if(c0==0) {
   print border
   print title
   c0=1
  }
if(c1==0) {
 print border
 print subtitle
 c1=1
 }
}
# print line of selected joke
new==1 { print $0 }
# print introduction
!selecting { print $0 }









